/**
 * CelebBabble Docenten Portaal JavaScript
 * Bestand: script.js
 * Auteur: [Student Naam]
 * Datum: Juni 2025
 * Beschrijving: Basis navigatie, zoekfunctionaliteit en audio controls
 */

/* ===================================
   INITIALISATIE
   =================================== */

document.addEventListener('DOMContentLoaded', function() {
    $(document).foundation();
    voegEventListenersToe();

    document.getElementById('interviewPagina').style.display = "none";
    document.getElementById('feedbackPagina').style.display = "none";
    console.log('🎭 CelebBabble geladen');
});

/* ===================================
   EVENT LISTENERS
   =================================== */

function voegEventListenersToe() {
    // Student knoppen
    document.querySelectorAll('.studentKaartKnop').forEach(function(knop) {
        knop.addEventListener('click', function() {
            const studentNaam = knop.getAttribute('data-student');
            openStudentDetail(studentNaam);
        });
        
        // Keyboard support
        knop.addEventListener('keydown', function(event) {
            if (event.key === 'Enter' || event.key === ' ') {
                event.preventDefault();
                knop.click();
            }
        });
    });
    
    // Gesprek knoppen
    document.querySelectorAll('.gesprekKaartKnop').forEach(function(knop) {
        knop.addEventListener('click', function() {
            const celebrity = knop.getAttribute('data-celebrity');
            const duur = knop.getAttribute('data-duur');
            selecteerGesprek(celebrity, duur);
        });
        
        // Keyboard support
        knop.addEventListener('keydown', function(event) {
            if (event.key === 'Enter' || event.key === ' ') {
                event.preventDefault();
                knop.click();
            }
        });
    });
    
    // Terug knoppen
    document.querySelectorAll('.terugKnop').forEach(function(knop) {
        knop.addEventListener('click', function() {
            const actie = knop.getAttribute('data-actie');
            if (actie === 'terugNaarOverzicht') {
                gaTerug();
            } else if (actie === 'terugNaarInterview') {
                gaTerugNaarInterview();
            }
        });
    });
    
    // Zoek functionaliteit
    const zoekInput = document.getElementById('zoekNaam');
    const zoekKnop = document.querySelector('.zoekKnop');
    if (zoekInput) {
        zoekInput.addEventListener('input', zoekStudenten);
    }
    if (zoekKnop) {
        zoekKnop.addEventListener('click', zoekStudenten);
    }
    
    // Klas filter
    const klasFilter = document.getElementById('klassenFilter');
    if (klasFilter) {
        klasFilter.addEventListener('change', filterOpKlas);
    }
    
    // Audio controls
    voegAudioControlsToe();
}

/* ===================================
   NAVIGATIE FUNCTIES
   =================================== */

function openStudentDetail(studentNaam) {
    document.title = 'Interview ' + studentNaam + ' - CelebBabble';
    
    document.getElementById('studentNaam').textContent = 'Interview: ' + studentNaam;
    document.getElementById('docentFeedback').value = 'Goed gedaan! Je uitspraak wordt steeds beter. Let vooral op je zinsintonatie bij vragen. Ook zou ik aanraden om wat meer variatie in je woordenschat te gebruiken. Blijf oefenen!';
    
    document.getElementById('overzichtPagina').style.display = 'none';
    document.getElementById('interviewPagina').style.display = 'block';

    document.body.scrollTop = 0; // For Safari
    document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
}

function gaTerug() {
    document.title = 'Docenten Portaal - CelebBabble';
    
    document.getElementById('interviewPagina').style.display = 'none';
    document.getElementById('feedbackPagina').style.display = 'none';
    document.getElementById('overzichtPagina').style.display = 'block';
}

function gaTerugNaarInterview() {
    document.getElementById('feedbackPagina').style.display = 'none';
    document.getElementById('interviewPagina').style.display = 'block';
}

function selecteerGesprek(celebrity, duur) {
    document.title = 'Feedback - ' + celebrity + ' - CelebBabble';
    
    document.getElementById('huidigGesprek').textContent = 'Gesprek: ' + celebrity + ' - ' + duur + ' min';
    
    document.getElementById('interviewPagina').style.display = 'none';
    document.getElementById('feedbackPagina').style.display = 'block';
}

/* ===================================
   ZOEK EN FILTER FUNCTIES
   =================================== */

function zoekStudenten() {
    const zoekInput = document.getElementById('zoekNaam');
    if (!zoekInput) return;
    
    const zoekTerm = zoekInput.value.toLowerCase();
    const studentKaarten = document.querySelectorAll('.studentKaart');
    
    studentKaarten.forEach(function(kaart) {
        const studentNaam = kaart.querySelector('h3').textContent.toLowerCase();
        
        if (zoekTerm === '' || studentNaam.includes(zoekTerm)) {
            kaart.style.display = 'block';
        } else {
            kaart.style.display = 'none';
        }
    });
}

function filterOpKlas() {
    const klasFilter = document.getElementById('klassenFilter');
    if (!klasFilter) return;
    
    const geselecteerdeKlas = klasFilter.value;
    const studentKaarten = document.querySelectorAll('.studentKaart');
    
    studentKaarten.forEach(function(kaart) {
        const studentKlas = kaart.getAttribute('data-klas');
        
        if (geselecteerdeKlas === 'all' || studentKlas === geselecteerdeKlas) {
            kaart.style.display = 'block';
        } else {
            kaart.style.display = 'none';
        }
    });
}

/* ===================================
   AUDIO FUNCTIONALITEIT
   =================================== */

function voegAudioControlsToe() {
    const audio = document.getElementById('studentAudio');
    const afspeelenKnop = document.getElementById('afspeelenKnop');
    const pauzerenKnop = document.getElementById('pauzerenKnop');
    const voorigeKnop = document.getElementById('voorigeKnop');
    const volgendeKnop = document.getElementById('volgendeKnop');
    const voortgangVulling = document.getElementById('voortgangVulling');
    const voortgangBalk = document.querySelector('.voortgangBalk');
    const huidigeTijd = document.getElementById('huidigeTijd');
    const totaleTijd = document.getElementById('totaleTijd');
    
    if (!audio) return;
    
    // Audio geladen event
    audio.addEventListener('loadedmetadata', function() {
        totaleTijd.textContent = formateerTijd(audio.duration);
    });
    
    // Time update event
    audio.addEventListener('timeupdate', function() {
        const progress = (audio.currentTime / audio.duration) * 100;
        voortgangVulling.style.width = progress + '%';
        huidigeTijd.textContent = formateerTijd(audio.currentTime);
    });
    
    // Play/Pause knop
    if (afspeelenKnop) {
        afspeelenKnop.addEventListener('click', function() {
            if (audio.paused) {
                audio.play();
                afspeelenKnop.textContent = '⏸';
                afspeelenKnop.setAttribute('aria-label', 'Pauzeren');
            } else {
                audio.pause();
                afspeelenKnop.textContent = '⏯';
                afspeelenKnop.setAttribute('aria-label', 'Afspelen');
            }
        });
    }
    
    // Pause knop
    if (pauzerenKnop) {
        pauzerenKnop.addEventListener('click', function() {
            audio.pause();
            afspeelenKnop.textContent = '⏯';
            afspeelenKnop.setAttribute('aria-label', 'Afspelen');
        });
    }
    
    // Vorige knop (naar begin)
    if (voorigeKnop) {
        voorigeKnop.addEventListener('click', function() {
            audio.currentTime = 0;
        });
    }
    
    // Volgende knop (naar einde)
    if (volgendeKnop) {
        volgendeKnop.addEventListener('click', function() {
            audio.currentTime = audio.duration;
        });
    }
    
    // Klik op voortgangsbalk
    if (voortgangBalk) {
        voortgangBalk.addEventListener('click', function(e) {
            const rect = voortgangBalk.getBoundingClientRect();
            const clickX = e.clientX - rect.left;
            const clickPercent = clickX / rect.width;
            audio.currentTime = clickPercent * audio.duration;
        });
    }
}

function formateerTijd(seconden) {
    const minuten = Math.floor(seconden / 60);
    const sec = Math.floor(seconden % 60);
    return minuten + ':' + (sec < 10 ? '0' : '') + sec;
}

/* ===================================
   ERROR HANDLING
   =================================== */

window.addEventListener('error', function(event) {
    console.error('JavaScript fout:', event.error);
});